#include <iostream>
#include <vector>

using namespace std;

vector<int> calculateXOR(const vector<int>& P, const vector<int>& Q) {
    vector<int> result;
    for (size_t i = 0; i < P.size(); ++i) {
        result.push_back(P[i] ^ Q[i]);
    }
    return result;
}

vector<int> findOptimalQ(const vector<int>& P) {
    int n = P.size() - 1;

    if (n % 2 == 0) {
        return P;
    }

    vector<int> Q = P;

    int j = 0;
    while (Q[j] == P[j]) {
        ++j;
    }

    if (Q[j] > P[j]) {
        Q[j] = P[j];
    } else {
        Q[j] = P[j] + 1;
    }

    return Q;
}

int main() {
    int T;
    cin >> T;

    while (T--) {
        int N;
        cin >> N;

        vector<int> P(N + 1);
        for (int i = 0; i <= N; ++i) {
            cin >> P[i];
        }

        vector<int> Q = findOptimalQ(P);

        vector<int> result = calculateXOR(P, Q);

        cout << result[0];
        for (int i = 1; i < result.size(); ++i) {
            cout << " " << result[i];
        }
        cout << endl;
    }

    return 0;
}